#include <bits/stdc++.h>

using namespace std;
using ll = long long;

const int mxN = 2e5+2, LOG = 19;
vector<int> g[mxN], g2[mxN];
int up[LOG][mxN], up2[LOG][mxN], dep[mxN], dep2[mxN];
void dfs(int s, int e = -1) {
    for (auto u : g[s]) {
        if (u == e) continue;
        dep[u] = dep[s] + 1, up[0][u] = s;
        dfs(u, s);
    }
}
void dfs2(int s, int e = -1) {
    for (auto u : g2[s]) {
        if (u == e) continue;
        dep2[u] = dep2[s] + 1, up2[0][u] = s;
        dfs2(u, s);
    }
}
int jump(int u, int k) {
    for (int i = 0; i < LOG; ++i) {
        if ((1 << i) & k) {
            u = up[i][u];
        }
    }
    return u;
}
int lca(int u, int v) {
    if (dep[u] < dep[v])    swap(u, v);
    u = jump(u, dep[u] - dep[v]);
    if (u == v) return u;
    for (int i = LOG-1; i >= 0; --i) {
        if (up[i][u] != up[i][v]) {
            u = up[i][u], v = up[i][v];
        }
    }
    return up[0][u];
}
int jump2(int u, int k) {
    for (int i = 0; i < LOG; ++i) {
        if ((1 << i) & k) {
            u = up2[i][u];
        }
    }
    return u;
}
int lca2(int u, int v) {
    if (dep2[u] < dep2[v])  swap(u, v);
    u = jump(u, dep2[u] - dep2[v]);
    if (u == v) return u;
    for (int i = LOG-1; i >= 0; --i) {
        if (up2[i][u] != up2[i][v]) {
            u = up2[i][u], v = up2[i][v];
        }
    }
    return up2[0][u];
}
void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans) {
    vector<pair<int, ll>> G[N+1]; bitset<mxN> vis; vis.reset();
    vector<int> v[N+1];
    for (int i = 1; i <= M; ++i) {
        G[U[i]].push_back({V[i], W[i]});
        G[V[i]].push_back({U[i], W[i]});
    }
    ll d[N+1];
    fill(d, d+N+1, 1e18);
    priority_queue<pair<ll, int>, vector<pair<ll, int>>, greater<>> pq;
    d[1] = 0;
    pq.push({0, 1});
    while (!pq.empty()) {
        auto [D, s] = pq.top(); pq.pop();
        if (vis[s]) continue;
        vis[s] = 1;
        for (auto [u, w] : G[s]) {
            if (d[u] > D + w) {
                d[u] = D + w;
                pq.push({d[u], u});
            }
            if (D == d[u] + w) {
                v[s].push_back(u);
                if (v[s].size() == 1) {
                    g[s].push_back(u), g[u].push_back(s);
                }
            }
        }
    }
    dfs(1);
    for (int i = 1; i < LOG; ++i) {
        for (int j = 1; j <= N; ++j) {
            up[i][j] = up[i-1][up[i-1][j]];
        }
    }
    for (int i = 2; i <= N; ++i) {
        int par = i;
        for (auto x : v[i]) {
            par = lca(par, x);
        }
        g2[par].push_back(i); g2[i].push_back(par);
    }
    dfs2(1);
    for (int i = 1; i < LOG; ++i) {
        for (int j = 1; j <= N; ++j) {
            up2[i][j] = up2[i-1][up2[i-1][j]];
        }
    }
    for (int i = 1; i <= Q; ++i) {
        Ans[i] = dep2[lca2(X[i], Y[i])] + 1;
    }
}